/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonarsource.sonarlint.core.plugin.PluginIndexProvider;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCache;

public class PluginCopier {
    private static final Logger LOG = Loggers.get(PluginCopier.class);
    private final PluginCache fileCache;
    private final PluginIndexProvider pluginIndexProvider;

    public PluginCopier(PluginCache fileCache, PluginIndexProvider pluginIndexProvider) {
        this.fileCache = fileCache;
        this.pluginIndexProvider = pluginIndexProvider;
    }

    public Map<String, PluginInfo> installRemotes() {
        return this.loadPlugins(this.pluginIndexProvider.references());
    }

    private Map<String, PluginInfo> loadPlugins(List<PluginIndexProvider.PluginReference> pluginReferences) {
        HashMap<String, PluginInfo> infosByKey = new HashMap<String, PluginInfo>();
        Profiler profiler = Profiler.create(LOG).startDebug("Load plugins");
        for (PluginIndexProvider.PluginReference pluginReference : pluginReferences) {
            File jarFile = this.getFromCacheOrCopy(pluginReference);
            PluginInfo info = PluginInfo.create(jarFile);
            infosByKey.put(info.getKey(), info);
        }
        profiler.stopDebug();
        return infosByKey;
    }

    @VisibleForTesting
    File getFromCacheOrCopy(PluginIndexProvider.PluginReference pluginReference) {
        URL url = pluginReference.getDownloadUrl();
        try {
            return this.fileCache.get(pluginReference.getFilename(), pluginReference.getHash(), new StandaloneModeFileDownloader(url)).toFile();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to copy plugin " + pluginReference.getFilename() + " from URL: " + url, e);
        }
    }

    private static class StandaloneModeFileDownloader
    implements PluginCache.Downloader {
        private URL url;

        StandaloneModeFileDownloader(URL url) {
            this.url = url;
        }

        @Override
        public void download(String filename, Path toFile) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copy plugin {} to {}", (Object)this.url, (Object)toFile);
            } else {
                LOG.info("Copy {}", (Object)StringUtils.substringAfterLast(this.url.getFile(), "/"));
            }
            FileUtils.copyURLToFile(this.url, toFile.toFile());
        }
    }
}

